// Simple JavaScript for MyImageShack
console.log('MyImageShack loaded');

// Gallery loader
async function loadGalleryImages() {
    try {
        const response = await fetch('/api/gallery.php');
        const data = await response.json();
        
        if (data.success && data.images.length > 0) {
            displayImages(data.images);
        } else {
            showEmptyGallery();
        }
    } catch (error) {
        console.error('Failed to load gallery:', error);
        showError();
    }
}

function displayImages(images) {
    const gallery = document.getElementById('imageGallery');
    if (!gallery) return;
    
    gallery.innerHTML = '';
    
    images.forEach(img => {
        const item = document.createElement('div');
        item.className = 'gallery-item';
        item.innerHTML = `
            <img src="${img.url}" alt="${img.title}" loading="lazy">
            <div class="image-info">
                <div class="image-title">${img.title}</div>
                <div class="image-meta">
                    <span><i class="far fa-calendar"></i> ${formatDate(img.date)}</span>
                    <span><i class="fas fa-hdd"></i> ${formatSize(img.size)}</span>
                </div>
            </div>
        `;
        gallery.appendChild(item);
    });
}

function formatDate(dateStr) {
    const date = new Date(dateStr);
    return date.toLocaleDateString('id-ID', {
        day: 'numeric',
        month: 'short',
        year: 'numeric'
    });
}

function formatSize(bytes) {
    if (bytes < 1024) return bytes + ' B';
    if (bytes < 1024 * 1024) return (bytes / 1024).toFixed(1) + ' KB';
    return (bytes / (1024 * 1024)).toFixed(1) + ' MB';
}

function showEmptyGallery() {
    const gallery = document.getElementById('imageGallery');
    if (!gallery) return;
    
    gallery.innerHTML = `
        <div style="grid-column: 1/-1; text-align: center; padding: 4rem; color: #94a3b8;">
            <i class="fas fa-image fa-3x" style="margin-bottom: 1rem;"></i>
            <h3 style="margin-bottom: 0.5rem;">Galeri Kosong</h3>
            <p>Unggah gambar pertama Anda!</p>
            <a href="upload-file.html" style="display: inline-block; margin-top: 1rem; padding: 0.8rem 1.5rem; background: #3b82f6; color: white; border-radius: 8px; text-decoration: none;">
                <i class="fas fa-upload"></i> Unggah Gambar
            </a>
        </div>
    `;
}

function showError() {
    const gallery = document.getElementById('imageGallery');
    if (!gallery) return;
    
    gallery.innerHTML = `
        <div style="grid-column: 1/-1; text-align: center; padding: 4rem; color: #ef4444;">
            <i class="fas fa-exclamation-triangle fa-3x" style="margin-bottom: 1rem;"></i>
            <h3 style="margin-bottom: 0.5rem;">Gagal memuat galeri</h3>
            <button onclick="location.reload()" style="margin-top: 1rem; padding: 0.8rem 1.5rem; background: #3b82f6; color: white; border: none; border-radius: 8px; cursor: pointer;">
                <i class="fas fa-sync-alt"></i> Coba Lagi
            </button>
        </div>
    `;
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    if (document.getElementById('imageGallery')) {
        loadGalleryImages();
    }
    
    // Search functionality
    const searchBox = document.getElementById('searchBox');
    if (searchBox) {
        searchBox.addEventListener('input', function() {
            const term = this.value.toLowerCase();
            document.querySelectorAll('.gallery-item').forEach(item => {
                const title = item.querySelector('.image-title').textContent.toLowerCase();
                item.style.display = title.includes(term) ? '' : 'none';
            });
        });
    }
});