<?php
// File: login.php
session_start();

// CREDENTIALS RAHASIA (HANYA ANDA YANG TAHU)
$SECRET_EMAIL = "admin@filemanager.store";
$SECRET_PASSWORD = "adminfileku";

// Jika sudah login, redirect ke admin page
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header('Location: admin.php');
    exit;
}

// Proses login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($email === $SECRET_EMAIL && $password === $SECRET_PASSWORD) {
        // Login berhasil
        $_SESSION['loggedin'] = true;
        $_SESSION['email'] = $email;
        $_SESSION['login_time'] = time();
        
        // Set cookie untuk remember (30 hari)
        setcookie('imageshack_auth', hash('sha256', $email . $password . 'SALT_RAHASIA'), time() + (30 * 24 * 60 * 60), '/');
        
        header('Location: admin.php');
        exit;
    } else {
        $error = "Email atau password salah!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - MyImageShack</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Segoe UI', sans-serif; }
        body { 
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-container {
            background: rgba(30, 41, 59, 0.9);
            border: 1px solid #334155;
            border-radius: 15px;
            padding: 2.5rem;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
        }
        .logo {
            text-align: center;
            margin-bottom: 2rem;
            color: #60a5fa;
        }
        .logo i {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        .logo h1 {
            font-size: 1.8rem;
            font-weight: 700;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        label {
            display: block;
            margin-bottom: 0.5rem;
            color: #cbd5e1;
            font-weight: 500;
        }
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 0.9rem 1rem;
            background: #1e293b;
            border: 1px solid #475569;
            border-radius: 8px;
            color: #f8fafc;
            font-size: 1rem;
            transition: all 0.3s;
        }
        input[type="email"]:focus,
        input[type="password"]:focus {
            outline: none;
            border-color: #60a5fa;
            box-shadow: 0 0 0 3px rgba(96, 165, 250, 0.1);
        }
        .login-btn {
            width: 100%;
            padding: 1rem;
            background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 1rem;
        }
        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(59, 130, 246, 0.3);
        }
        .error-message {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid #ef4444;
            color: #fca5a5;
            padding: 0.8rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            text-align: center;
            display: none;
        }
        .error-message.show {
            display: block;
        }
        .login-hint {
            text-align: center;
            color: #94a3b8;
            font-size: 0.9rem;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid #334155;
        }
        .admin-only {
            color: #fbbf24;
            font-weight: 600;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <i class="fas fa-lock"></i>
            <h1>FILE MANAGER</h1>
            <div class="admin-only">Admin Login</div>
        </div>
        
        <?php if (isset($error)): ?>
        <div class="error-message show" id="errorMessage">
            <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
        </div>
        <?php endif; ?>
        
        <form method="POST" action="" id="loginForm">
            <div class="form-group">
                <label for="email"><i class="fas fa-envelope"></i>  LOGIN</label>
                <input type="email" id="email" name="email" required 
                       placeholder="Username/Email">
            </div>
            
            <div class="form-group">
                <label for="password"><i class="fas fa-key"></i>  Password</label>
                <input type="password" id="password" name="password" required 
                       placeholder="••••••••••••">
            </div>
            
            <button type="submit" class="login-btn">
                <i class="fas fa-sign-in-alt"></i> Masuk ke Admin Panel
            </button>
        </form>
        
        <div class="login-hint">
            <p><i class="fas fa-shield-alt"></i> FileManager Platform Unggah Gambar</p>
            <p style="font-size: 0.8rem; margin-top: 0.5rem; opacity: 0.7;">
                Sesi akan berakhir setelah 24 jam tidak aktif
            </p>
        </div>
    </div>
    
    <script>
    // Clear error on focus
    document.getElementById('email').addEventListener('focus', function() {
        document.getElementById('errorMessage')?.classList.remove('show');
    });
    
    document.getElementById('password').addEventListener('focus', function() {
        document.getElementById('errorMessage')?.classList.remove('show');
    });
    
    // Auto-hide error after 5 seconds
    setTimeout(() => {
        document.getElementById('errorMessage')?.classList.remove('show');
    }, 5000);
    </script>
</body>
</html>