
import React from 'react';

interface MetricCardProps {
  label: string;
  value: string | number;
  subValue?: string;
  icon: React.ReactNode;
  colorClass: string;
}

const MetricCard: React.FC<MetricCardProps> = ({ label, value, subValue, icon, colorClass }) => {
  return (
    <div className="glass p-6 rounded-2xl flex items-center space-x-4 hover:border-indigo-500/50 transition-all duration-300 group">
      <div className={`p-4 rounded-xl ${colorClass} bg-opacity-10 text-xl group-hover:scale-110 transition-transform`}>
        {icon}
      </div>
      <div>
        <p className="text-slate-400 text-sm font-medium">{label}</p>
        <div className="flex items-baseline space-x-2">
          <h3 className="text-2xl font-bold text-white">{value}</h3>
          {subValue && <span className="text-xs text-slate-500">{subValue}</span>}
        </div>
      </div>
    </div>
  );
};

export default MetricCard;
