<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$uploadsDir = '../uploads/';
$images = [];

if (is_dir($uploadsDir)) {
    $files = scandir($uploadsDir);
    
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..') {
            $filePath = $uploadsDir . $file;
            $fileInfo = pathinfo($filePath);
            
            // Hanya file gambar
            if (in_array(strtolower($fileInfo['extension']), ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'])) {
                $imageSize = getimagesize($filePath);
                
                $images[] = [
                    'id' => uniqid(),
                    'filename' => $file,
                    'title' => $fileInfo['filename'],
                    'url' => 'uploads/' . $file,
                    'date' => date('Y-m-d', filemtime($filePath)),
                    'size' => filesize($filePath),
                    'width' => $imageSize ? $imageSize[0] : 0,
                    'height' => $imageSize ? $imageSize[1] : 0,
                    'type' => mime_content_type($filePath)
                ];
            }
        }
    }
}

// Urutkan berdasarkan tanggal terbaru
usort($images, function($a, $b) {
    return strtotime($b['date']) - strtotime($a['date']);
});

echo json_encode([
    'success' => true,
    'count' => count($images),
    'images' => $images
]);
?>