<?php
// File: admin-actions.php
session_start();

// Cek login
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

// Actions
$action = $_GET['action'] ?? '';

if ($action === 'refresh') {
    // Refresh session
    $_SESSION['login_time'] = time();
    echo json_encode(['success' => true, 'message' => 'Session refreshed']);
    
} elseif ($action === 'delete') {
    // Delete file
    $filename = $_GET['file'] ?? '';
    
    if (empty($filename)) {
        echo json_encode(['success' => false, 'message' => 'No filename specified']);
        exit;
    }
    
    // Security check - hanya boleh hapus dari uploads folder
    $filepath = 'uploads/' . basename($filename);
    
    if (!file_exists($filepath)) {
        echo json_encode(['success' => false, 'message' => 'File not found']);
        exit;
    }
    
    // Cek apakah file gambar
    $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'];
    $extension = strtolower(pathinfo($filepath, PATHINFO_EXTENSION));
    
    if (!in_array($extension, $allowed_extensions)) {
        echo json_encode(['success' => false, 'message' => 'Invalid file type']);
        exit;
    }
    
    // Hapus file
    if (unlink($filepath)) {
        echo json_encode(['success' => true, 'message' => 'File deleted']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Delete failed']);
    }
    
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid action']);
}